<?php

namespace App\Http\Controllers;

use PDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;


class ExportController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    // public function exportDownloadPdf(Request $request)
    // {
    //     // Data dummy
    //     $data = [
    //         [
    //             'nama_inovasi' => 'Inovasi A',
    //             'nama_dinas' => 'Dinas A',
    //             'deskripsi_inovasi' => 'Deskripsi inovasi A',
    //             'regulasi' => 'http://example.com/regulasiA',
    //             'dokumentasi' => 'http://example.com/dokumentasiA',
    //             'tahun' => 2024,
    //             'kategori' => 'smart governance',
    //             'items' => [
    //                 [
    //                     'tanggal' => '1 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan A1',
    //                     'gambar' => 'path_to_image_1.png'
    //                 ],
    //                 [
    //                     'tanggal' => '2 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan A2',
    //                     'gambar' => 'path_to_image_2.png'
    //                 ],
    //                 [
    //                     'tanggal' => '3 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan A3',
    //                     'gambar' => 'path_to_image_3.png'
    //                 ],
    //             ]
    //         ],
    //         [
    //             'nama_inovasi' => 'Inovasi B',
    //             'nama_dinas' => 'Dinas B',
    //             'deskripsi_inovasi' => 'Deskripsi inovasi B',
    //             'regulasi' => 'http://example.com/regulasiB',
    //             'dokumentasi' => 'http://example.com/dokumentasiB',
    //             'tahun' => 2024,
    //             'kategori' => 'smart branding',
    //             'items' => [
    //                 [
    //                     'tanggal' => '4 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan B1',
    //                     'gambar' => 'path_to_image_4.png'
    //                 ],
    //                 [
    //                     'tanggal' => '5 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan B2',
    //                     'gambar' => 'path_to_image_5.png'
    //                 ],
    //                 [
    //                     'tanggal' => '6 Januari 2024',
    //                     'deskripsi_kegiatan' => 'Deskripsi kegiatan B3',
    //                     'gambar' => 'path_to_image_6.png'
    //                 ],
    //             ]
    //         ]
    //     ];

    //     $groupedData = [];
    //     foreach ($data as $innovation) {
    //         $kategori = $innovation['kategori'];
    //         if (!isset($groupedData[$kategori])) {
    //             $groupedData[$kategori] = [];
    //         }
    //         $groupedData[$kategori][] = $innovation;
    //     }
    //      $defaultCategories = [
    //     'smart governance',
    //     'smart living',
    //     'smart education',
    //     'smart health',
    //     'smart environment',
    //     'smart transportation'
    // ];

    //     $logoPath = public_path('Logo.png'); // Path to your logo
    //     $logoBase64 = base64_encode(file_get_contents($logoPath));

    //      $htmlContent = $this->generateTableHtml($groupedData, $logoBase64);

     

    
    // // Generate PDF menggunakan Dompdf
    // // $pdf = PDF::loadView("pages.usulan", compact("data", "logoBase64"));
    // $pdf = Pdf::loadHTML($htmlContent);
    // $pdf->setPaper([0, 0, 498.4252, 708.6625], 'portrait');
    // return $pdf->stream('inovasi.pdf');
    // // // Menghasilkan nama file
    // // $timestamp = time();
    // // $timePrefix = date('Y-m-d_H-i-s', $timestamp);
    // // $filename = 'Rekap_Surat_masuk'.$timePrefix.'.pdf';

    // // // Mengirimkan file PDF sebagai respon
    // // // return $pdf->download($filename);
    // //    return $pdf->stream($filename);
    // }


public function exportDownloadPdf(Request $request)
{
    $data = $request->input('data');

            if (!$data) {
                return response()->json([
                    'success' => false,
                    'message' => 'Data tidak ditemukan',
                ], 400);
            }

    // Data dummy
    // $data = [
    //     [
    //         'nama_inovasi' => 'Inovasi A',
    //         'nama_dinas' => 'Dinas Komunikasi Informatika Statistik Dan Persandian',
    //         'deskripsi_inovasi' => 'Deskripsi inovasi A',
    //         'regulasi' => 'http://example.com/regulasiA',
    //         'dokumentasi' => 'http://example.com/dokumentasiA',
    //         'tahun' => 2024,
    //         'kategori' => 'smart governance',
    //         'items' => [
    //             [
    //                 'tanggal' => '1 Januari 2024',
    //                 'deskripsi_kegiatan' => 'Deskripsi kegiatan A1',
    //                 'gambar' => 'path_to_image_1.png'
    //             ],
                
    //         ]
    //     ],
    //     [
    //         'nama_inovasi' => 'Inovasi A',
    //         'nama_dinas' => 'Dinas Komunikasi Informatika Statistik Dan Persandian',
    //         'deskripsi_inovasi' => 'Deskripsi inovasi A',
    //         'regulasi' => 'http://example.com/regulasiA',
    //         'dokumentasi' => 'http://example.com/dokumentasiA',
    //         'tahun' => 2024,
    //         'kategori' => 'smart governance',
    //         'items' => [
    //             [
    //                 'tanggal' => '1 Januari 2024',
    //                 'deskripsi_kegiatan' => 'Deskripsi kegiatan A1',
    //                 'gambar' => 'path_to_image_1.png'
    //             ],
    //             [
    //                 'tanggal' => '2 Januari 2024',
    //                 'deskripsi_kegiatan' => 'Deskripsi kegiatan A2',
    //                 'gambar' => 'path_to_image_2.png'
    //             ]
    //         ]
    //     ],
    //     [
    //         'nama_inovasi' => 'Inovasi A',
    //         'nama_dinas' => 'Dinas Kesehatan',
    //         'deskripsi_inovasi' => 'Deskripsi inovasi A',
    //         'regulasi' => 'http://example.com/regulasiA',
    //         'dokumentasi' => 'http://example.com/dokumentasiA',
    //         'tahun' => 2024,
    //         'kategori' => 'smart governance',
    //         'items' => [
    //             [
    //                 'tanggal' => '1 Januari 2024',
    //                 'deskripsi_kegiatan' => 'Deskripsi kegiatan A1',
    //                 'gambar' => 'path_to_image_1.png'
    //             ],
    //             [
    //                 'tanggal' => '2 Januari 2024',
    //                 'deskripsi_kegiatan' => 'Deskripsi kegiatan A2',
    //                 'gambar' => 'path_to_image_2.png'
    //             ]
    //         ]
    //     ],
    //     [
    //         'nama_inovasi' => 'Inovasi A',
    //         'nama_dinas' => 'Dinas Kesehatan',
    //         'deskripsi_inovasi' => 'Deskripsi inovasi A',
    //         'regulasi' => 'http://example.com/regulasiA',
    //         'dokumentasi' => 'http://example.com/dokumentasiA',
    //         'tahun' => 2024,
    //         'kategori' => 'smart branding',
    //         'items' => [
            
    //         ]
    //     ],
    //     // Data dummy untuk kategori lain
    // ];

    // Daftar kategori default
    $defaultCategories = [
        'smart governance',
        'smart living',
        'smart branding',
        'smart society',
        'smart environment',
        'smart economy'
    ];

    // Kelompokkan data berdasarkan kategori
    $groupedData = [];
    foreach ($data as $innovation) {
        $kategori = $innovation['kategori'];
        if (!isset($groupedData[$kategori])) {
            $groupedData[$kategori] = [];
        }
        $groupedData[$kategori][] = $innovation;
    }

    // Tambahkan kategori default yang tidak ada dalam data
    foreach ($defaultCategories as $category) {
        if (!isset($groupedData[$category])) {
            $groupedData[$category] = [];
        }
    }

    // Convert logo to base64
    $path = public_path('Logo.png'); // Ganti dengan path logo Anda
    $logoBase64 = base64_encode(file_get_contents($path));

    // Generate HTML
    $htmlContent = $this->generateTableHtml($groupedData, $logoBase64);

    // Generate PDF
    $pdf = Pdf::loadHTML($htmlContent);
    $pdf->setPaper('A4', 'portrait');

    // Stream the PDF
    return $pdf->stream('inovasi.pdf');
}


   
    // private function generateTableHtml($groupedData, $logoBase64)
    // {
    //     $htmlContent = '';

    //     foreach ($groupedData as $kategori => $inovasiList) {
    //         $htmlContent .= "
    //         <table style='border-collapse: collapse; width: 100%; text-transform: capitalize; margin-bottom: 6px !important;'>
    //             <thead>
    //                 <tr>
    //                     <th colspan='6' style='border: 1px solid #080808; text-align: left !important; padding: 4px; font-size: 10px; background-color: #29569f !important; color: white;'>
    //                         <h1 style='font-size: 14px; margin: 0;'>". ucfirst($kategori) ."</h1>
    //                     </th>
    //                 </tr>
    //             </thead>
    //             <tbody>
    //                 <tr>
    //                     <td colspan='6' style='padding: 4; border: 1px solid #080808;'>
    //                         <table style='margin-bottom: 8px; margin-left: 0px !important; margin-top: 10px !important; background: #96C9F4 !important;'>
    //                             <tr>
    //                                 <td><strong style='font-size: 12px'>Nama OPD</strong></td>
    //                                 <td>:</td>
    //                                 <td><strong style='font-size: 12px'>". $inovasiList[0]['nama_dinas'] ."</strong></td>
    //                             </tr>
    //                         </table>
                            
    //                         <table style='width: 100%; margin: 0; border-collapse: collapse;'>
    //                             <thead>
    //                                 <tr>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 2% !important;'>No</th>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 18% !important;'>Nama Inovasi</th>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 50% !important;'>Deskripsi Inovasi</th>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Regulasi</th>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Dokumentasi</th>
    //                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>Tahun</th>
    //                                 </tr>
    //                             </thead>
    //                             <tbody>";

    //         foreach ($inovasiList as $index => $inovasi) {
    //             $htmlContent .= "
    //                 <tr>
    //                     <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". ($index + 1) ."</td>
    //                     <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['nama_inovasi'] ."</td>
    //                     <td style='border: 1px solid #080808; text-align: justify; padding: 4px; font-size: 12px !important;'>". $inovasi['deskripsi_inovasi'] ."</td>
    //                     <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['regulasi'] ."'>File Regulasi</a></td>
    //                     <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['dokumentasi'] ."'>File Dokumentasi</a></td>
    //                     <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['tahun'] ."</td>
    //                 </tr>";
    //         }

    //         foreach ($inovasiList as $inovasi) {
    //             if (!empty($inovasi['items'])) {
    //                 $htmlContent .= "
    //                 <tr>
    //                     <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #d4edda; font-weight: bold !important;'>Progres Kegiatan</td>
    //                 </tr>";

    //                 foreach ($inovasi['items'] as $itemIndex => $item) {
    //                     $htmlContent .= "
    //                     <tr>
    //                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". ($itemIndex + 1) ."</td>
    //                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". $item['tanggal'] ."</td>
    //                         <td colspan='3' style='border: 1px solid #080808; text-align: justify; padding: 4px !important; font-size: 12px;'>". $item['deskripsi_kegiatan'] ."</td>
    //                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'><img src='data:image/png;base64,". $logoBase64 ."' alt='Logo' style='width: 50px' /></td>
    //                     </tr>";
    //                 }
    //             }
    //         }

    //         $htmlContent .= "
    //                             </tbody>
    //                         </table>
    //                     </td>
    //                 </tr>
    //             </tbody>
    //         </table>";
    //     }

    //     return $htmlContent;
    // }

//     private function generateTableHtml($groupedData, $logoBase64)
// {
//     $htmlContent = '';

//     foreach ($groupedData as $kategori => $inovasiList) {
//         $htmlContent .= "
//         <table style='border-collapse: collapse; width: 100%; text-transform: capitalize; margin-bottom: 6px !important;'>
//             <thead>
//                 <tr>
//                     <th colspan='6' style='border: 1px solid #080808; text-align: left !important; padding: 4px; font-size: 10px; background-color: #29569f !important; color: white;'>
//                         <h1 style='font-size: 14px; margin: 0;'>". ucfirst($kategori) ."</h1>
//                     </th>
//                 </tr>
//             </thead>
//             <tbody>
//                 <tr>
//                     <td colspan='6' style='padding: 4; border: 1px solid #080808;'>
//                         <table style='margin-bottom: 8px; margin-left: 0px !important; margin-top: 10px !important; background: #96C9F4 !important;'>
//                             <tr>
//                                 <td><strong style='font-size: 12px'>Nama OPD</strong></td>
//                                 <td>:</td>
//                                 <td><strong style='font-size: 12px'>". (isset($inovasiList[0]['nama_dinas']) ? $inovasiList[0]['nama_dinas'] : '') ."</strong></td>
//                             </tr>
//                         </table>
                        
//                         <table style='width: 100%; margin: 0; border-collapse: collapse;'>
//                             <thead>
//                                 <tr>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 2% !important;'>No</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 18% !important;'>Nama Inovasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 50% !important;'>Deskripsi Inovasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Regulasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Dokumentasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>Tahun</th>
//                                 </tr>
//                             </thead>
//                             <tbody>";

//         if (empty($inovasiList)) {
//             $htmlContent .= "
//                 <tr>
//                     <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>Tidak ada data untuk kategori ini</td>
//                 </tr>";
//         } else {
//             foreach ($inovasiList as $index => $inovasi) {
//                 $htmlContent .= "
//                     <tr>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". ($index + 1) ."</td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['nama_inovasi'] ."</td>
//                         <td style='border: 1px solid #080808; text-align: justify; padding: 4px; font-size: 12px !important;'>". $inovasi['deskripsi_inovasi'] ."</td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['regulasi'] ."'>File Regulasi</a></td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['dokumentasi'] ."'>File Dokumentasi</a></td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['tahun'] ."</td>
//                     </tr>";
//             }

//             foreach ($inovasiList as $inovasi) {
//                 if (!empty($inovasi['items'])) {
//                     $htmlContent .= "
//                     <tr>
//                         <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #d4edda; font-weight: bold !important;'>Progres Kegiatan</td>
//                     </tr>";

//                     foreach ($inovasi['items'] as $itemIndex => $item) {
//                         $htmlContent .= "
//                         <tr>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". ($itemIndex + 1) ."</td>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". $item['tanggal'] ."</td>
//                             <td colspan='3' style='border: 1px solid #080808; text-align: justify; padding: 4px !important; font-size: 12px;'>". $item['deskripsi_kegiatan'] ."</td>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'><img src='data:image/png;base64,". $logoBase64 ."' alt='Logo' style='width: 50px' /></td>
//                         </tr>";
//                     }
//                 }
//             }
//         }

//         $htmlContent .= "
//                 </tbody>
//             </table>
//         </td>
//     </tr>
// </tbody>
// </table>";
//     }

//     return $htmlContent;
// }

// private function generateTableHtml($groupedData, $logoBase64)
// {
//     // HTML untuk kop
//     $headerHtml = "
//     <table class='tabel-kop' style='width: 100%; text-align: center; margin-bottom: 20px; font-family: Arial, sans-serif;'>
//         <tr>
//             <td class='kop' style='width: 10%;'>
//                 <img src='data:image/png;base64,{$logoBase64}' alt='Logo' style='width: 70%;' />
//             </td>
//             <td class='kop'>
//                 <h3 style='text-align: center; font-size: 16px !important; margin: 0;'>PEMERINTAH KABUPATEN BANYUASIN</h3>
//                 <h3 style='text-align: center; font-size: 18px !important; margin: 0;'>DINAS KOMUNIKASI, INFORMATIKA STATISTIK DAN PERSANDIAN</h3>
//                 <h5 style='text-align: center; font-size: 9px !important; margin: 0;'>KOMPLEK PERKANTORAN PEMERINTAH KABUPATEN BANYUASIN</h5>
//                 <p style='text-align: center; font-size: 9px !important; margin: 0;'>
//                     Jl. Ishak Usman No. 24 Pangkalan Balai, Provinsi Sumatera Selatan Telp.
//                     0711-7690014/Fax.0711-7690099
//                 </p>
//                 <p style='text-align: center; font-size: 9px !important; margin: 0;'>
//                     Email : Diskominfo@banyuasinkab.go.id Website : http://diskominfo.banyuasinkab.go.id
//                 </p>
//             </td>
//         </tr>
//     </table>
//     <hr style='margin-top: -15px; margin-bottom: 20px; border: 3px solid black !important;' />
//     <h3 style='text-align: center; margin-bottom: 8px; font-family: Arial, sans-serif;'>Rekap Data Inovasi Kabupaten Banyuasin</h3>";

//     // HTML untuk konten tabel
//     $contentHtml = '';

//     foreach ($groupedData as $kategori => $inovasiList) {
//         $contentHtml .= "
//         <table style='border-collapse: collapse; width: 100%; text-transform: capitalize; margin-bottom: 6px !important; font-family: Arial, sans-serif;'>
//             <thead>
//                 <tr>
//                     <th colspan='6' style='border: 1px solid #080808; text-align: left !important; padding: 4px; font-size: 10px; background-color: #29569f !important; color: white;'>
//                         <h1 style='font-size: 14px; margin: 0;'>". ucfirst($kategori) ."</h1>
//                     </th>
//                 </tr>
//             </thead>
//             <tbody>
//                 <tr>
//                     <td colspan='6' style='padding: 4; border: 1px solid #080808;'>
//                         <table style='margin-bottom: 8px; margin-left: 0px !important; margin-top: 10px !important; background: #96C9F4 !important; font-family: Arial, sans-serif;'>
//                             <tr>
//                                 <td><strong style='font-size: 12px'>Nama OPD</strong></td>
//                                 <td>:</td>
//                                 <td><strong style='font-size: 12px'>". (isset($inovasiList[0]['nama_dinas']) ? $inovasiList[0]['nama_dinas'] : '') ."</strong></td>
//                             </tr>
//                         </table>
                        
//                         <table style='width: 100%; margin: 0; border-collapse: collapse; font-family: Arial, sans-serif;'>
//                             <thead>
//                                 <tr>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 2% !important;'>No</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 18% !important;'>Nama Inovasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 50% !important;'>Deskripsi Inovasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Regulasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Dokumentasi</th>
//                                     <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>Tahun</th>
//                                 </tr>
//                             </thead>
//                             <tbody>";

//         if (empty($inovasiList)) {
//             $contentHtml .= "
//                 <tr>
//                     <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>Tidak ada data untuk kategori ini</td>
//                 </tr>";
//         } else {
//             foreach ($inovasiList as $index => $inovasi) {
//                 $contentHtml .= "
//                     <tr>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". ($index + 1) ."</td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['nama_inovasi'] ."</td>
//                         <td style='border: 1px solid #080808; text-align: justify; padding: 4px; font-size: 12px !important;'>". $inovasi['deskripsi_inovasi'] ."</td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['regulasi'] ."'>File Regulasi</a></td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['dokumentasi'] ."'>File Dokumentasi</a></td>
//                         <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['tahun'] ."</td>
//                     </tr>";
//             }

//             foreach ($inovasiList as $inovasi) {
//                 if (!empty($inovasi['items'])) {
//                     $contentHtml .= "
//                     <tr>
//                         <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #d4edda; font-weight: bold !important;'>Progres Kegiatan</td>
//                     </tr>";

//                     foreach ($inovasi['items'] as $itemIndex => $item) {
//                         $contentHtml .= "
//                         <tr>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". ($itemIndex + 1) ."</td>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". $item['tanggal'] ."</td>
//                             <td colspan='3' style='border: 1px solid #080808; text-align: justify; padding: 4px !important; font-size: 12px;'>". $item['deskripsi_kegiatan'] ."</td>
//                             <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'><img src='data:image/png;base64,". $logoBase64 ."' alt='Logo' style='width: 50px' /></td>
//                         </tr>";
//                     }
//                 }
//             }
//         }

//         $contentHtml .= "
//                 </tbody>
//             </table>
//         </td>
//     </tr>
// </tbody>
// </table>";
//     }

//     return $headerHtml . $contentHtml;
// }

private function generateTableHtml($groupedData, $logoBase64)
{
    // HTML untuk kop
    $headerHtml = "
    <table class='tabel-kop' style='width: 100%; text-align: center; margin-bottom: 20px; font-family: Arial, sans-serif;'>
        <tr>
            <td class='kop' style='width: 10%;'>
                <img src='data:image/png;base64,{$logoBase64}' alt='Logo' style='width: 70%;' />
            </td>
            <td class='kop'>
                <h3 style='text-align: center; font-size: 16px !important; margin: 0;'>PEMERINTAH KABUPATEN BANYUASIN</h3>
                <h3 style='text-align: center; font-size: 18px !important; margin: 0;'>DINAS KOMUNIKASI, INFORMATIKA STATISTIK DAN PERSANDIAN</h3>
                <h5 style='text-align: center; font-size: 9px !important; margin: 0;'>KOMPLEK PERKANTORAN PEMERINTAH KABUPATEN BANYUASIN</h5>
                <p style='text-align: center; font-size: 9px !important; margin: 0;'>
                    Jl. Ishak Usman No. 24 Pangkalan Balai, Provinsi Sumatera Selatan Telp.
                    0711-7690014/Fax.0711-7690099
                </p>
                <p style='text-align: center; font-size: 9px !important; margin: 0;'>
                    Email : Diskominfo@banyuasinkab.go.id Website : http://diskominfo.banyuasinkab.go.id
                </p>
            </td>
        </tr>
    </table>
    <hr style='margin-top: -15px; margin-bottom: 20px; border: 3px solid black !important;' />
    <h3 style='text-align: center; margin-bottom: 8px; font-family: Arial, sans-serif;'>Rekap Data Inovasi Kabupaten Banyuasin</h3>";

    // HTML untuk konten tabel
    $contentHtml = '';

    foreach ($groupedData as $kategori => $inovasiList) {
    $contentHtml .= "
    <table style='border-collapse: collapse; width: 100%; text-transform: capitalize; margin-bottom: 6px !important; font-family: Arial, sans-serif;'>
        <thead>
            <tr>
                <th colspan='6' style='border: 1px solid #080808; text-align: left !important; padding: 4px; font-size: 10px; background-color: #29569f !important; color: white;'>
                    <h1 style='font-size: 14px; margin: 0;'>". ucfirst($kategori) ."</h1>
                </th>
            </tr>
        </thead>
        <tbody>";

    if (empty($inovasiList)) {
        $contentHtml .= "
            <tr>
                <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>Tidak ada data untuk kategori ini</td>
            </tr>";
    } else {
        $processedOpds = []; // Array untuk menyimpan OPD yang sudah diproses dalam kategori ini

        foreach ($inovasiList as $index => $inovasi) {
            $namaDinas = isset($inovasi['nama_dinas']) ? $inovasi['nama_dinas'] : '';

            // Cek dan tambahkan tabel OPD jika belum diproses
            if (!in_array($namaDinas, $processedOpds)) {
                // Tambahkan nama OPD ke array yang sudah diproses
                $processedOpds[] = $namaDinas;

                // Tambahkan tabel OPD
                $contentHtml .= "
                <tr>
                    <td colspan='6' style='padding: 4; border: 1px solid #080808;'>
                        <table style='margin-bottom: 8px; margin-left: 0px !important; margin-top: 10px !important; background: #96C9F4 !important; font-family: Arial, sans-serif;'>
                            <tr>
                                <td><strong style='font-size: 12px'>Nama OPD</strong></td>
                                <td>:</td>
                                <td><strong style='font-size: 12px'>". $namaDinas ."</strong></td>
                            </tr>
                        </table>
                    </td>
                </tr>";
            }

            // Tambahkan baris inovasi
            $contentHtml .= "
            <tr>
                <td colspan='6' style='padding: 4; border: 1px solid #080808;'>
                    <table style='width: 100%; margin: 0; border-collapse: collapse; font-family: Arial, sans-serif;'>
                        <thead>
                            <tr>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 2% !important;'>No</th>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 18% !important;'>Nama Inovasi</th>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important; width: 50% !important;'>Deskripsi Inovasi</th>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Regulasi</th>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>File Dokumentasi</th>
                                <th style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>Tahun</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". ($index + 1) ."</td>
                                <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['nama_inovasi'] ."</td>
                                <td style='border: 1px solid #080808; text-align: justify; padding: 4px; font-size: 12px !important;'>". $inovasi['deskripsi_inovasi'] ."</td>
                                <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['regulasi'] ."'>File Regulasi</a></td>
                                <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'><a href='". $inovasi['dokumentasi'] ."'>File Dokumentasi</a></td>
                                <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;'>". $inovasi['tahun'] ."</td>
                            </tr>";

            if (!empty($inovasi['items'])) {
                $contentHtml .= "
                <tr>
                    <td colspan='6' style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #d4edda; font-weight: bold !important;'>Progres Kegiatan</td>
                </tr>";

                foreach ($inovasi['items'] as $itemIndex => $item) {
                    $contentHtml .= "
                    <tr>
                        <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". ($itemIndex + 1) ."</td>
                        <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'>". $item['tanggal'] ."</td>
                        <td colspan='3' style='border: 1px solid #080808; text-align: justify; padding: 4px !important; font-size: 12px;'>". $item['deskripsi_kegiatan'] ."</td>
                        <td style='border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;'><img src='data:image/png;base64,". $logoBase64 ."' alt='Logo' style='width: 50px' /></td>
                    </tr>";
                }
            }else {
                 $contentHtml .= "
                <tr> ; background-color: #f8d7da; font-weight: bold !important;'>Progres Kegiatan</td>
                </tr>";
            }

            $contentHtml .= "
                            </tbody>
                        </table>
                    </td>
                </tr>";
        }
    }

    $contentHtml .= "
        </tbody>
    </table>";
    }

    return $headerHtml . $contentHtml;
}


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
