<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8" />
    <title>Document</title>
    <style>
        * {
            font-family: Arial, Helvetica, sans-serif;
            margin: 4px 8px 0px 8px;
        }
        h2 {
            display: block;
            margin: auto;
            text-align: center;
            margin-bottom: 8px;
            font-family: sans-serif;
            font-size: 1px;
        }

        hr {
            border: none !important;
            border-bottom: 4.5pt solid black !important;
            margin-top: -20px !important;
        }

        h3 {
            font-size: 15px !important;
        }

        .tabel-kop,
        .kop td,
        .kop th {
            border: none !important;
            padding: 2px;
            font-size: 11px;
        }

        .kop img {
            width: 50px;
        }
    </style>
</head>
<body>
    <table class="tabel-kop" style="width: 100%; text-align: center; margin-bottom: 20px">
        <tr>
            <td class="kop" style="width: 10%">
                <img src="data:image/png;base64,<?php echo e($logoBase64); ?>" alt="Logo" style="width: 70%" />
            </td>
            <td class="kop">
                <h3 style="text-align: center; font-size: 16px !important">PEMERINTAH KABUPATEN BANYUASIN</h3>
                <h3 style="text-align: center; font-size: 18px !important">DINAS KOMUNIKASI, INFORMATIKA STATISTIK DAN PERSANDIAN</h3>
                <h5 style="text-align: center; font-size: 9px !important">KOMPLEK PERKANTORAN PEMERINTAH KABUPATEN BANYUASIN</h5>
                <p style="text-align: center; font-size: 9px !important">
                    Jl. Ishak Usman No. 24 Pangkalan Balai, Provinsi Sumatera Selatan Telp. 0711-7690014/Fax.0711-7690099
                </p>
                <p style="text-align: center">
                    Email : Diskominfo@banyuasinkab.go.id Website : http://diskominfo.banyuasinkab.go.id
                </p>
            </td>
        </tr>
    </table>
    <hr style="margin-top: -15px; margin-bottom: 20px" border: 3px solid black !important; />

    <h3 style="text-align: center; margin-bottom: 8px;">Rekap Data Inovasi Kabupaten Banyuasin</h3>

    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kategori => $inovasiList): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $kategoriNames = [
                'smart governance' => 'Smart Governance',
                'smart branding' => 'Smart Branding',
                'smart living' => 'Smart Living',
                'smart society' => 'Smart Society',
                'smart economy' => 'Smart Economy',
                'smart environment' => 'Smart Environment',
            ];
            $kategoriName = $kategoriNames[$kategori] ?? 'Kategori Tidak Diketahui';
        ?>

        <table style="border-collapse: collapse; width: 100%; text-transform: capitalize; margin-bottom: 6px !important;">
            <thead>
                <tr>
                    <th style="border: 1px solid #080808; text-align: left !important; padding: 4px; font-size: 10px; background-color: #29569f !important; color: white;">
                        <h1 style="font-size: 14px"><?php echo e($kategoriName); ?></h1>
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $inovasiList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inovasi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td style="border: 1px solid #080808; padding: 4px; font-size: 10px; text-align: left;">
                            <div style="margin: 0px 40px 0 40px !important;">
                                <table style="border-collapse: collapse; width: 100%; text-transform: capitalize;">
                                    <tr>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">No</th>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">Nama Inovasi</th>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">Deskripsi Inovasi</th>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">File Regulasi</th>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">File Dokumentasi</th>
                                        <th style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px !important;">Tahun</th>
                                    </tr>
                                    <tr>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($index); ?></td>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($inovasi['nama_inovasi']); ?></td>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($inovasi['deskripsi_inovasi']); ?></td>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><a href="<?php echo e($inovasi['regulasi']); ?>">Link</a></td>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><a href="<?php echo e($inovasi['dokumentasi']); ?>">Link</a></td>
                                        <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($inovasi['tahun']); ?></td>
                                    </tr>

                                    <?php if(count($inovasi['items']) == 0): ?>
                                        <tr>
                                            <td colspan="6" style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #f8d7da; font-weight:bold !important;">Progres Kegiatan</td>
                                        </tr>
                                        <tr>
                                            <td colspan="6" style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #f8d7da;">Tidak ada progres sama sekali</td>
                                        </tr>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="6" style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px; background-color: #d4edda; font-weight:bold !important;">Progres Kegiatan</td>
                                        </tr>
                                        <?php $__currentLoopData = $inovasi['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemIndex => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($itemIndex + 1); ?></td>
                                                <td style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;"><?php echo e($item['tanggal']); ?></td>
                                                <td colspan="2" style="border: 1px solid #080808; text-align: center; padding: 25px !important; font-size: 12px;"><?php echo e($item['deskripsi_kegiatan']); ?></td>
                                                <td colspan="2" style="border: 1px solid #080808; text-align: center; padding: 4px; font-size: 12px;">
                                                    <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents(public_path($item['gambar'])))); ?>" alt="Image" style="width: 50px" />
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </table>
                                <?php if(($index + 1) % 13 === 0): ?>
                                    <div style="page-break-before: always; margin-top: 100px !important;"></div>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH /Users/fransbachtiar/Documents/frans bachtiar/DISKOMINFO/APLIKASI/SIEMAS/exportpdf-siemas/resources/views/pdf_template.blade.php ENDPATH**/ ?>